/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.buildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.constant.ToolType;
import com.minecolonies.coremod.colony.buildings.AbstractBuildingWorker;
import com.minecolonies.coremod.colony.buildings.modules.BuildingResourcesModule;
import com.minecolonies.coremod.colony.buildings.utils.BuilderBucket;
import com.minecolonies.coremod.colony.buildings.utils.BuildingBuilderResource;
import com.minecolonies.coremod.entity.ai.util.BuildingStructureHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingStructureBuilder
extends AbstractBuildingWorker {
    public static final int MAX_BUILDING_LEVEL = 5;
    private static final int COUNT_TO_STORE_POS = 50;
    private BlockPos progressPos;
    private BuildingStructureHandler.Stage progressStage;
    private int progressCounter = 0;
    private Map<Integer, List<BlockPos>> fluidsToRemove = new LinkedHashMap<Integer, List<BlockPos>>();

    public AbstractBuildingStructureBuilder(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public int buildingRequiresCertainAmountOfItem(ItemStack stack, List<ItemStorage> localAlreadyKept, boolean inventory) {
        if (inventory) {
            int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
            String key = stack.func_77977_a() + "-" + hashCode;
            if (this.getRequiredResources() != null && this.getRequiredResources().getResourceMap().containsKey(key)) {
                int qtyToKeep = this.getRequiredResources().getResourceMap().get(key);
                if (localAlreadyKept.contains(new ItemStorage(stack))) {
                    for (ItemStorage storage : localAlreadyKept) {
                        if (!storage.equals(new ItemStorage(stack))) continue;
                        if (storage.getAmount() >= qtyToKeep) {
                            return stack.func_190916_E();
                        }
                        int kept = storage.getAmount();
                        if (qtyToKeep >= kept + stack.func_190916_E()) {
                            storage.setAmount(kept + stack.func_190916_E());
                            return 0;
                        }
                        storage.setAmount(qtyToKeep);
                        return qtyToKeep - kept - stack.func_190916_E();
                    }
                } else {
                    if (qtyToKeep >= stack.func_190916_E()) {
                        localAlreadyKept.add(new ItemStorage(stack));
                        return 0;
                    }
                    localAlreadyKept.add(new ItemStorage(stack, qtyToKeep, false));
                    return stack.func_190916_E() - qtyToKeep;
                }
            }
            if (this.checkIfShouldKeepTool(ToolType.PICKAXE, stack, localAlreadyKept) || this.checkIfShouldKeepTool(ToolType.SHOVEL, stack, localAlreadyKept) || this.checkIfShouldKeepTool(ToolType.AXE, stack, localAlreadyKept) || this.checkIfShouldKeepTool(ToolType.HOE, stack, localAlreadyKept)) {
                localAlreadyKept.add(new ItemStorage(stack, 1, true));
                return 0;
            }
            return stack.func_190916_E();
        }
        return super.buildingRequiresCertainAmountOfItem(stack, localAlreadyKept, inventory);
    }

    private boolean checkIfShouldKeepTool(ToolType type, ItemStack stack, List<ItemStorage> localAlreadyKept) {
        if (ItemStackUtils.hasToolLevel(stack, type, 0, this.getMaxToolLevel())) {
            for (ItemStorage storage : localAlreadyKept) {
                if (ItemStackUtils.getMiningLevel(stack, type) > ItemStackUtils.getMiningLevel(storage.getItemStack(), type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        for (BuildingBuilderResource stack : this.getFirstModuleOccurance(BuildingResourcesModule.class).getNeededResources().values()) {
            toKeep.put(itemstack -> ItemStackUtils.compareItemStacksIgnoreStackSize(stack.getItemStack(), itemstack, true, false), (Tuple<Integer, Boolean>)new Tuple((Object)stack.getAmount(), (Object)true));
        }
        return toKeep;
    }

    @Override
    public ItemStack forceTransferStack(ItemStack stack, World world) {
        ItemStack itemStack = super.forceTransferStack(stack, world);
        if (ItemStackUtils.isEmpty(itemStack).booleanValue()) {
            this.markDirty();
        }
        return itemStack;
    }

    @Override
    public void deserializeNBT(CompoundNBT compound) {
        super.deserializeNBT(compound);
        if (compound.func_74764_b("newProgressPos")) {
            this.progressPos = BlockPosUtil.read(compound, "newProgressPos");
            this.progressStage = BuildingStructureHandler.Stage.values()[compound.func_74762_e("newProgressStage")];
        }
        if (compound.func_74764_b("fluidsToRemove")) {
            this.fluidsToRemove.clear();
            ListNBT fluidsToRemove = (ListNBT)compound.func_74781_a("fluidsToRemove");
            fluidsToRemove.forEach(fluidsRemove -> {
                int y = ((CompoundNBT)fluidsRemove).func_74762_e("yLevel");
                ListNBT positions = (ListNBT)((CompoundNBT)fluidsRemove).func_74781_a("positions");
                ArrayList<BlockPos> fluids = new ArrayList<BlockPos>();
                for (int i = 0; i < positions.size(); ++i) {
                    fluids.add(BlockPosUtil.readFromListNBT(positions, i));
                }
                this.fluidsToRemove.put(y, fluids);
            });
        }
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        if (this.progressPos != null) {
            BlockPosUtil.write(compound, "newProgressPos", this.progressPos);
            compound.func_74768_a("newProgressStage", this.progressStage.ordinal());
        }
        ListNBT fluidsToRemove = new ListNBT();
        this.fluidsToRemove.forEach((y, fluids) -> {
            CompoundNBT fluidsRemove = new CompoundNBT();
            ListNBT positions = new ListNBT();
            fluids.forEach(fluid -> BlockPosUtil.writeToListNBT(positions, fluid));
            fluidsRemove.func_218657_a("positions", (INBT)positions);
            fluidsRemove.func_74768_a("yLevel", y.intValue());
            fluidsToRemove.add((Object)fluidsRemove);
        });
        compound.func_218657_a("fluidsToRemove", (INBT)fluidsToRemove);
        return compound;
    }

    @Override
    public void serializeToView(@NotNull PacketBuffer buf) {
        super.serializeToView(buf);
        buf.func_180714_a(this.getMainCitizen() == null || this.colony.getCitizenManager().getCivilian(this.getMainCitizen().getId()) == null ? "" : this.getMainCitizen().getName());
    }

    public Map<String, BuildingBuilderResource> getNeededResources() {
        return this.getFirstModuleOccurance(BuildingResourcesModule.class).getNeededResources();
    }

    @Nullable
    public BuilderBucket getRequiredResources() {
        return this.getFirstModuleOccurance(BuildingResourcesModule.class).getRequiredResources();
    }

    public boolean hasResourceInBucket(ItemStack stack) {
        int hashCode = stack.func_77942_o() ? stack.func_77978_p().hashCode() : 0;
        String key = stack.func_77977_a() + "-" + hashCode;
        return this.getRequiredResources() != null && this.getRequiredResources().getResourceMap().containsKey(key);
    }

    public void addNeededResource(@Nullable ItemStack res, int amount) {
        this.getFirstModuleOccurance(BuildingResourcesModule.class).addNeededResource(res, amount);
        this.markDirty();
    }

    public void reduceNeededResource(ItemStack res, int amount) {
        this.getFirstModuleOccurance(BuildingResourcesModule.class).reduceNeededResource(res, amount);
        this.markDirty();
    }

    public void resetNeededResources() {
        this.getFirstModuleOccurance(BuildingResourcesModule.class).resetNeededResources();
        this.markDirty();
    }

    public boolean requiresResourceForBuilding(ItemStack stack) {
        return this.getFirstModuleOccurance(BuildingResourcesModule.class).requiresResourceForBuilding(stack);
    }

    public abstract void searchWorkOrder();

    public void setProgressPos(BlockPos blockPos, BuildingStructureHandler.Stage stage) {
        this.progressPos = blockPos;
        if (this.progressCounter > 50 || blockPos == null || stage != this.progressStage) {
            this.markDirty();
            this.progressCounter = 0;
        } else {
            ++this.progressCounter;
        }
        this.progressStage = stage;
    }

    @Nullable
    public com.minecolonies.api.util.Tuple<BlockPos, BuildingStructureHandler.Stage> getProgress() {
        if (this.progressPos == null) {
            return null;
        }
        return new com.minecolonies.api.util.Tuple<BlockPos, BuildingStructureHandler.Stage>(this.progressPos, this.progressStage);
    }

    public int getResourceBatchMultiplier() {
        return 1;
    }

    public Map<Integer, List<BlockPos>> getFluidsToRemove() {
        return this.fluidsToRemove;
    }

    public void checkOrRequestBucket(@Nullable BuilderBucket requiredResources, ICitizenData worker, boolean workerInv) {
        this.getFirstModuleOccurance(BuildingResourcesModule.class).checkOrRequestBucket(requiredResources, worker, workerInv);
    }

    public void nextStage() {
        this.getFirstModuleOccurance(BuildingResourcesModule.class).nextStage();
    }

    public void setTotalStages(int total) {
        this.getFirstModuleOccurance(BuildingResourcesModule.class).setTotalStages(total);
    }

    @Nullable
    public BuilderBucket getNextBucket() {
        return this.getFirstModuleOccurance(BuildingResourcesModule.class).getNextBucket();
    }
}

